<?php

namespace Ptb\OrderDesk\Transformers;

class AddressTransformer
{
    protected string $firstName;
    protected string $lastName;
    protected ?string $companyName;
    protected string $address1;
    protected ?string $address2;
    protected string $city;
    protected string $state;
    protected string $postalCode;
    protected string $country;
    protected ?string $phone;

    public function __construct()
    {
        $this->firstName = '';
        $this->lastName = '';
        $this->companyName = null;
        $this->address1 = '';
        $this->address2 = null;
        $this->city = '';
        $this->state = '';
        $this->postalCode = '';
        $this->country = '';
        $this->phone = null;
    }

    /**
     * @return string
     */
    public function getFirstName(): string
    {
        return $this->firstName;
    }

    /**
     * @param string $firstName
     * @return AddressTransformer
     */
    public function setFirstName(string $firstName): AddressTransformer
    {
        $this->firstName = $firstName;
        return $this;
    }

    /**
     * @return string
     */
    public function getLastName(): string
    {
        return $this->lastName;
    }

    /**
     * @param string $lastName
     * @return AddressTransformer
     */
    public function setLastName(string $lastName): AddressTransformer
    {
        $this->lastName = $lastName;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getCompanyName(): ?string
    {
        return $this->companyName;
    }

    /**
     * @param string|null $companyName
     * @return AddressTransformer
     */
    public function setCompanyName(?string $companyName): AddressTransformer
    {
        $this->companyName = $companyName;
        return $this;
    }

    /**
     * @return string
     */
    public function getAddress1(): string
    {
        return $this->address1;
    }

    /**
     * @param string $address1
     * @return AddressTransformer
     */
    public function setAddress1(string $address1): AddressTransformer
    {
        $this->address1 = $address1;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getAddress2(): ?string
    {
        return $this->address2;
    }

    /**
     * @param string|null $address2
     * @return AddressTransformer
     */
    public function setAddress2(?string $address2): AddressTransformer
    {
        $this->address2 = $address2;
        return $this;
    }

    /**
     * @return string
     */
    public function getCity(): string
    {
        return $this->city;
    }

    /**
     * @param string $city
     * @return AddressTransformer
     */
    public function setCity(string $city): AddressTransformer
    {
        $this->city = $city;
        return $this;
    }

    /**
     * @return string
     */
    public function getState(): string
    {
        return $this->state;
    }

    /**
     * @param string $state
     * @return AddressTransformer
     */
    public function setState(string $state): AddressTransformer
    {
        $this->state = $state;
        return $this;
    }

    /**
     * @return string
     */
    public function getPostalCode(): string
    {
        return $this->postalCode;
    }

    /**
     * @param string $postalCode
     * @return AddressTransformer
     */
    public function setPostalCode(string $postalCode): AddressTransformer
    {
        $this->postalCode = $postalCode;
        return $this;
    }

    /**
     * @return string
     */
    public function getCountry(): string
    {
        return $this->country;
    }

    /**
     * @param string $country
     * @return AddressTransformer
     */
    public function setCountry(string $country): AddressTransformer
    {
        $this->country = $country;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getPhone(): ?string
    {
        return $this->phone;
    }

    /**
     * @param string|null $phone
     * @return AddressTransformer
     */
    public function setPhone(?string $phone): AddressTransformer
    {
        $this->phone = $phone;
        return $this;
    }

    /**
     * @return array
     */
    public function toArray(): array
    {
        return array_filter([
            'first_name' => $this->firstName,
            'last_name' => $this->lastName,
            'company' => $this->companyName,
            'address1' => $this->address1,
            'address2' => $this->address2,
            'city' => $this->city,
            'state' => $this->state,
            'postal_code' => $this->postalCode,
            'country' => $this->country,
            'phone' => $this->phone
        ]);
    }

}