<?php

namespace Ptb\Freshdesk\Services;

use Ptb\Freshdesk\Freshdesk;

final class GroupService
{
    /**
     * @var Freshdesk
     */
    private Freshdesk $freshdesk;

    public function __construct()
    {
        $this->freshdesk = new Freshdesk();
    }

    /**
     * @param int $id
     * @return array|mixed
     */
    public function show
    (
        int $id
    ): mixed
    {
        $response = $this->freshdesk
            ->getJsonClient()
            ->get("/api/v2/groups/{$id}");

        return $response->json();
    }

    /**
     * @return array|mixed
     */
    public function fetch(): mixed
    {
        $response = $this->freshdesk
            ->getJsonClient()
            ->get("/api/v2/groups");

        return $response->json();
    }
}