<?php

namespace Ptb\Freshdesk\Services;

use Ptb\Freshdesk\Freshdesk;

final class AgentService
{
    /**
     * @var Freshdesk
     */
    private Freshdesk $freshdesk;

    public function __construct()
    {
        $this->freshdesk = new Freshdesk();
    }

    /**
     * @param int $id
     * @return mixed
     */
    public function show
    (
        int $id
    ): mixed
    {
        $response = $this->freshdesk
            ->getJsonClient()
            ->get("/api/v2/agents/{$id}");

        return $response->json();
    }

    /**
     * @param string|null $email
     * @param string|null $mobile
     * @param $phone
     * @return array|mixed
     */
    public function fetch
    (
        string $email = null,
        string $mobile = null,
        $phone = null
    ): mixed
    {
        $payload = collect();
        if (!empty($email)) {
            $payload->put('email', $email);
        }

        if (!empty($mobile)) {
            $payload->put('mobile', $mobile);
        }

        if (!empty($phone)) {
            $payload->put('phone', $phone);
        }

        $response = $this->freshdesk
            ->getJsonClient()
            ->get(
                url: "/api/v2/agents",
                query: $payload->toArray()
            );

        return $response->json();
    }
}