<?php

return [
    'url' => env('FRESHDESK_URL'),
    'apiKey' => env('FRESHDESK_API_KEY', ''),

    'agentService' => [
        // placeholder
    ],

    'groupService' => [
        // placeholder
    ],

    'ticketService' => [
        /**
         * Default group name that all tickets created will be assigned to
         */
        'group_name' => env('FRESHDESK_TICKET_GROUP_NAME', ''),

        /**
         * Default agent email address that all tickets created will be assigned to
         */
        'agent_email' => env('FRESHDESK_TICKET_AGENT_EMAIL', ''),

        /**
         * Store in .env as comma-separated list of email addresses to add as CC's to any ticket
         * created
         */
        'cc_emails' => explode(',', env('FRESHDESK_TICKET_CC', '')),

        /**
         * Store in .env as comma-separated list of tag values that will be added to any ticket
         * created
         */
        'tags' => explode(',', env('FRESHDESK_TICKET_TAGS', ''))
    ]
];
