<?php

namespace Ptb\Freshdesk\Services;

use Ptb\Freshdesk\Freshdesk;

final class TicketService
{
    /**
     * @var Freshdesk
     */
    private Freshdesk $freshdesk;

    public function __construct()
    {
        $this->freshdesk = new Freshdesk();
    }

    /**
     * @param array $attributes
     * @return array|mixed
     */
    public function create
    (
        array $attributes = []
    ): mixed
    {
        $client = $this->freshdesk->getJsonClient();
        if (!empty(data_get($attributes, 'attachments'))) {
            // set client to multipart
            $client = $this->freshdesk->getMultipartClient();

            // add attachments to request
            $attachments = data_get($attributes, 'attachments');
            foreach ($attachments as $attachment) {
                if (!empty(data_get($attachment, 'data'))) {
                    $client->attach(
                        name: 'attachments[]',
                        contents: data_get($attachment, 'data'),
                        filename: data_get($attachment, 'name')
                    );
                }
            }

            // remove the attachments key from the payload data since its already added to the request
            unset($attributes['attachments']);
        }

        // handle cc_emails
        if (!empty(data_get($attributes, 'cc_emails'))) {
            $cc_emails = data_get($attributes, 'cc_emails');
            foreach ($cc_emails as $index => $cc_email) {
                data_set($attributes, "cc_emails[{$index}]", $cc_email);
            }
            unset($attributes['cc_emails']);
        }

        // handle tags
        if (!empty(data_get($attributes, 'tags'))) {
            $tags = data_get($attributes, 'tags');
            foreach ($tags as $index => $tag) {
                data_set($attributes, "tags[{$index}]", $tag);
            }
            unset($attributes['tags']);
        }

        $response = $client
            ->post(
                url: '/api/v2/tickets',
                data: $attributes
            );

        return $response->json();
    }

    /**
     * @param int $id
     * @return array|mixed
     */
    public function show
    (
        int $id
    ): mixed
    {
        $response = $this->freshdesk
            ->getJsonClient()
            ->get("/api/tickets/v2/{$id}");

        return $response->json();
    }

    public function update(int $id, array $attributes = [])
    {
        // put /api/tickets/v2/{id}
    }

    /**
     * @param int $id
     * @return array|mixed
     */
    public function destroy
    (
        int $id
    ): mixed
    {
        $response = $this->freshdesk
            ->getJsonClient()
            ->delete("/api/tickets/v2/{$id}");

        return $response->json();
    }

    /**
     * @param int $id
     * @return array|mixed
     */
    public function restore
    (
        int $id
    ): mixed
    {
        $response = $this->freshdesk
            ->getJsonClient()
            ->put("/api/tickets/v2/{$id}/restore");

        return $response->json();
    }


}