<?php

namespace Ptb\Freshdesk\Services;

use Ptb\Freshdesk\Freshdesk;

final class AgentService
{
    /**
     * @var Freshdesk
     */
    private Freshdesk $freshdesk;

    public function __construct()
    {
        $this->freshdesk = new Freshdesk();
    }

    public function show(int $id)
    {
        $response = $this->freshdesk->getJsonClient()->get("/api/v2/agents/{$id}");

        return $response->json();
    }

    public function fetch(string $email = null, string $mobile = null, $phone = null)
    {
        $payload = collect();
        if (!empty($email)) {
            $payload->put('email', $email);
        }

        if (!empty($mobile)) {
            $payload->put('mobile', $mobile);
        }

        if (!empty($phone)) {
            $payload->put('phone', $phone);
        }

        $response = $this->freshdesk->getJsonClient()->get("/api/v2/agents", $payload->toArray());

        return $response->json();
    }
}