<?php

namespace Ptb\Freshdesk;

use Illuminate\Http\Client\PendingRequest;
use Illuminate\Http\Client\RequestException;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Http;

final class Freshdesk
{
    /**
     * @var PendingRequest
     */
    protected PendingRequest $http;

    /**
     * Freshdesk constructor. Creates an internal instance of PendingRequest
     * used for communicating with Freshdesk API.
     */
    public function __construct()
    {
        $this->http = Http::acceptJson()
            ->baseUrl(config('freshdesk.url'))
            ->withBasicAuth(
                username: config('freshdesk.apiKey'),
                password: 'X'
            );
    }

    /**
     * Returns a PendingRequest configured as a multipart request suited for
     * sending data such as file attachments
     *
     * @return PendingRequest
     */
    public function getMultipartClient(): PendingRequest
    {
        return $this->http->asMultipart();
    }

    /**
     * Returns a PendingRequest configured as a JSON request suited for
     * sending data formatted as JSON
     *
     * @return PendingRequest
     */
    public function getJsonClient(): PendingRequest
    {
        return $this->http->asJson();
    }
}
