<?php

namespace Ptb\Freshdesk\Messages;

use Illuminate\Http\Client\RequestException;
use Ptb\Freshdesk\Freshdesk;

class FreshdeskMessage
{
    private Freshdesk $http;

    public array $attachments = [];
    public array $cc_emails = [];
    public string $description;
    public string $email;
    public ?int $group_id;
    public ?string $name;
    public int $priority = 4;
    public ?int $responder_id;
    public int $source = 1;
    public int $status = 2;
    public string $subject;
    public array $tags = [];
    public ?string $type;

    public function __construct()
    {
        $this->http = new Freshdesk;
    }


    public function attachment(string $attachmentName, mixed $attachmentData): static
    {
        $this->attachments[] = [
            'name' => $attachmentName,
            'data' => $attachmentData
        ];

        return $this;
    }

    /**
     * @param string $email
     * @return $this
     * @throws RequestException
     */
    public function agent(string $email): static
    {
        $agents = $this->http->getAgents();
        $agent = $agents->where('contact.email', $email)->first();

        if ($agent) {
            $this->responder_id = data_get($agent, 'id');
        }

        return $this;
    }

    /**
     * @param string $email
     * @return $this
     */
    public function cc(string $email): static
    {
        $this->cc_emails[] = $email;

        return $this;
    }

    /**
     * @param string $view
     * @param mixed $viewData
     * @return $this
     */
    public function description(string $view, mixed $viewData): static
    {
        $this->description = view($view, $viewData)->render();

        return $this;
    }

    /**
     * @param string $email
     * @return $this
     */
    public function email(string $email): static
    {
        $this->email = $email;

        return $this;
    }

    /**
     * @throws RequestException
     */
    public function group(string $groupName): static
    {
        $groups = $this->http->getGroups();
        $group = $groups->where('name', $groupName)->first();

        if ($group) {
            $this->group_id = data_get($group, 'id');
        }

        return $this;
    }

    /**
     * @param string $name
     * @return $this
     */
    public function name(string $name): static
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @param string $subject
     * @return $this
     */
    public function subject(string $subject): static
    {
        $this->subject = $subject;

        return $this;
    }

    /**
     * @param string $tag
     * @return $this
     */
    public function tag(string $tag): static
    {
        $this->tags[] = $tag;

        return $this;
    }

    /**
     * @param string $type
     * @return $this
     */
    public function type(string $type): static
    {
        $this->type = $type;

        return $this;
    }
}
