<?php

namespace Ptb\Freshdesk;

use Illuminate\Http\Client\PendingRequest;
use Illuminate\Http\Client\RequestException;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Http;

class Freshdesk
{
    /**
     * @var PendingRequest
     */
    protected PendingRequest $http;

    /**
     *
     */
    public function __construct()
    {
        $this->http = Http::asJson()
            ->acceptJson()
            ->baseUrl(config('freshdesk.url'))
            ->withBasicAuth(
                username: config('freshdesk.apiKey'),
                password: 'X'
            );
    }

    /**
     * @return Collection
     * @throws RequestException
     */
    public function getAgents(): Collection
    {
        $response = $this->http
            ->get(url: '/api/v2/agents');

        if ($response->successful()) {
            return collect($response->json());
        }

        report($response->throw());
    }

    /**
     * @return Collection
     * @throws RequestException
     */
    public function getGroups(): Collection
    {
        $response = $this->http
            ->get(url: '/api/v2/groups');

        if ($response->successful()) {
            return collect($response->json());
        }

        report($response->throw());
    }

    /**
     * @param array $payload
     * @return mixed
     * @throws RequestException
     */
    public function createTicket
    (
        array $payload
    ): mixed
    {
        $response = $this->http
            ->post(
                url: '/api/v2/tickets',
                data: $payload
            );

        if ($response->successful()) {
            return $response->json();
        }

        report($response->throw());
    }
}
