<?php

namespace Ptb\Freshdesk;

use Illuminate\Notifications\ChannelManager;
use Illuminate\Support\Facades\Notification;
use Illuminate\Support\ServiceProvider;
use Ptb\Freshdesk\Channels\FreshdeskChannel;

class PackageServiceProvider extends ServiceProvider
{
    public function register(): void
    {
        Notification::resolved(function (ChannelManager $service) {
            $service->extend(
                driver: 'freshdesk',
                callback: fn($app) => new FreshdeskChannel()
            );
        });
    }

    public function boot()
    {
        $this->mergeConfigFrom(
            path: __DIR__ . '/../config/freshdesk.php',
            key: 'freshdesk'
        );
    }
}
