<?php

namespace Ptb\Freshdesk\Channels;

use Illuminate\Http\Client\RequestException;
use Illuminate\Notifications\Notification;
use Ptb\Freshdesk\Freshdesk;
use Ptb\Freshdesk\Messages\FreshdeskMessage;

class FreshdeskChannel
{
    protected Freshdesk $http;

    public function __construct()
    {
        $this->http = new Freshdesk();
    }

    /**
     * @param $notifiable
     * @param Notification $notification
     * @return mixed
     * @throws RequestException
     */
    public function send($notifiable, Notification $notification): mixed
    {
        return $this->http->createTicket($this->buildJsonPayload(
            $notification->toFreshdesk($notifiable)
        ));
    }

    /**
     * @param FreshdeskMessage $message
     * @return array
     */
    protected function buildJsonPayload(FreshdeskMessage $message): array
    {
        $optionalFields = array_filter([
            'attachments' => data_get($message, 'attachments'),
            'cc_emails' => data_get($message, 'cc_emails'),
            'group_id' => data_get($message, 'group_id'),
            'name' => data_get($message, 'name'),
            'responder_id' => data_get($message, 'responder_id'),
            'tags' => data_get($message, 'tags'),
            'type' => data_get($message, 'type')
        ]);

        return array_merge([
            'description' => data_get($message, 'description'),
            'email' => data_get($message, 'email'),
            'priority' => data_get($message, 'priority'),
            'source' => data_get($message, 'source'),
            'status' => data_get($message, 'status'),
            'subject' => data_get($message, 'subject')
        ], $optionalFields);
    }
}
