<?php

namespace Ptb\CartRover\Actions;

use Illuminate\Http\Client\RequestException;
use Illuminate\Support\Facades\Http;

class ViewInventoryByProduct
{
    protected string $_username;
    protected string $_password;
    protected string $_url;

    public function __construct()
    {
        $this->_url = str_replace('v1/cart', 'v1/merchant', config('cart-rover-cart.api_url'));
        $this->_username = config('cart-rover-cart.api_username');
        $this->_password = config('cart-rover-cart.api_key');
    }

    /**
     * @param string $sku
     * @return mixed
     * @throws RequestException
     */
    public function handle(string $sku) : mixed
    {
        $response = Http::asJson()
            ->withBasicAuth($this->_username, $this->_password)
            ->get(sprintf('%s/inventory/%s', $this->_url, $sku));

        if ($response->successful()) {
            return $response->json();
        }

        $response->throw();
    }
}