<?php

namespace Ptb\CartRover\Actions;

use Illuminate\Support\Facades\Http;

class ViewInventory
{
    protected string $_username;
    protected string $_password;
    protected string $_url;

    public function __construct()
    {
        $this->_url = str_replace('v1/cart', 'v1/merchant', config('cart-rover-cart.api_url'));
        $this->_username = config('cart-rover-cart.api_username');
        $this->_password = config('cart-rover-cart.api_key');
    }

    /**
     * @param array $filters
     * @return mixed
     * @throws \Illuminate\Http\Client\RequestException
     */
    public function handle(array $filters = []): mixed
    {
        $response = Http::asJson()
            ->withBasicAuth($this->_username, $this->_password)
            ->get(sprintf('%s/inventory', $this->_url), $filters);

        if ($response->successful()) {
            return $response->json();
        }

        $response->throw();
    }
}