<?php

namespace Ptb\CartRover\Actions;

use Illuminate\Support\Facades\Http;
use Ptb\CartRover\Models\Error;
use Ptb\CartRover\Models\Order;
use function collect;

class ViewOrdersByStatus
{
    protected string $_username;
    protected string $_password;
    protected string $_url;

    public function __construct()
    {
        $this->_url = config('cart-rover-cart.api_url');
        $this->_username = config('cart-rover-cart.api_username');
        $this->_password = config('cart-rover-cart.api_key');
    }

    /**
     * @param string $status
     * @param array $filters
     * @return mixed
     */
    public function handle(string $status, array $filters = []): mixed
    {
        $response = Http::asJson()
            ->withBasicAuth($this->_username, $this->_password)
            ->get(sprintf('%s/orders/list/%s', $this->_url, $status), $filters);

        if ($response->successful()) {
            if ($response->json('success_code')) {
                $orders = collect();
                foreach ($response->json('response') as $item) {
                    $orders->push(Order::make($item));
                }
                return $orders;
            } else {
                return $response->json();
            }
        }
    }
}