<?php

namespace Ptb\CartRover\Actions;

use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Http;

class NewOrders
{
    protected string $_username;
    protected string $_password;
    protected string $_url;

    public function __construct()
    {
        $this->_url = config('cart-rover-cart.api_url');
        $this->_username = config('cart-rover-cart.api_username');
        $this->_password = config('cart-rover-cart.api_key');
    }

    /**
     * @param Collection $orders
     * @return mixed
     */
    public function handle(Collection $orders): mixed
    {
        $response = Http::asJson()
            ->withBasicAuth($this->_username, $this->_password)
            ->get(sprintf('%s/orders/batch', $this->_url), $orders->toArray());

        if ($response->successful()) {
            return $response->json();
        }
    }
}