<?php

namespace Ptb\CartRover\Actions;

use Illuminate\Support\Facades\Http;
use Ptb\CartRover\Models\Order;

class ViewOrder
{
    protected string $_username;
    protected string $_password;
    protected string $_url;

    public function __construct()
    {
        $this->_url = config('cart-rover-cart.api_url');
        $this->_username = config('cart-rover-cart.api_username');
        $this->_password = config('cart-rover-cart.api_key');
    }

    /**
     * @param string $reference
     * @param array $filters
     * @return mixed
     */
    public function handle(string $reference, array $filters = []): mixed
    {
        $response = Http::asJson()
            ->withBasicAuth($this->_username, $this->_password)
            ->get(sprintf('%s/orders/%s', $this->_url, $reference), $filters);

        if ($response->successful()) {
            if ($response->json('success_code')) {
                return Order::make($response->json('response'));
            } else {
                return $response->json();
            }
        }
    }
}