# Installation

## Existing Laravel Project

- From project root
```
mkdir packages/ptbsolutions/laravel-cart-rover-cart
```

- Download current version

```
https://bitbucket.org/threenorthagency/laravel-cart-rover-cart/get/x.x.x.zip
```

- Unzip into directory created above
```
cd packages/ptbsolutions/laravel-cart-rover-cart
unzip downloads/x.x.x.zip
```

## Update composer.json

```
repositories: [
    {
        "type": "path",
        "url": "packages/ptbsolutions/laravel-cart-rover-cart",
        "options": {
            "symlink": true
        }
    }
]
```

## Install package

```
composer require ptbsolutions/laravel-cart-rover-cart
php artisan vendor:publish --provider=\Ptb\CartRover\Cart\PackageServiceProvider
```

# Usage

## Update .env

```
CART_ROVER_API_USERNAME=xxxx
CART_ROVER_API_KEY=xxxx
```

## Create an order

```
$order = new \Ptb\CartRover\Cart\Models\Order();
$order->... = 'myvalue';

$result = (new \Ptb\CartRover\Cart\Actions\NewOrder)->handle($order);
if (data_get($result, 'success_code')) {
    // my order was created
} else {
    // my order had an error
}
```

## Get status of order

```
$reference = 'my-unique-order-reference';
$result = (new \Ptb\CartRover\Cart\Actions\ViewOrderStatus)->handle($reference);
if (data_get($result, 'success_code')) {
    if (data_get($result, 'response.order_status') === 'shipped') {
        $shipments = data_get($result, 'response.order_status.shipments');
        // update my local order with shipment details
        
        // we need to update the order status in cart rover to be confirmed
        // acknowledging that we've received the shipment information
        $result = (new \Ptb\CartRover\Cart\Actions\UpdateOrderStatus)->handle($reference, \Ptb\CartRover\Cart\Models\Order::StatusConfirmed, $shipments);
        if (data_get($result, 'success_code') {
            // my confirmation was successful
        } else {
            // my confirmation request had an error
        }
    }
} else {
    // my request had an error
}
```

## Get inventory for sku

```
$sku = 'my-sku';
$result = (new \Ptb\CartRover\Cart\Actions\ViewInventoryByProduct)->handle($sku);
if (data_get($result, 'success_code')) {
    $qty_available = data_get($result, 'qty_available');
    // update my local inventory
} else {
    // my request had an error
}
```
