<?php

namespace Ptb\CartRover\Cart\Actions;

use Illuminate\Support\Facades\Http;
use Ptb\CartRover\Cart\Models\Order;

class NewOrder
{
    protected string $_username;
    protected string $_password;
    protected string $_url;

    public function __construct()
    {
        $this->_url = config('cart-rover-cart.api_url');
        $this->_username = config('cart-rover-cart.api_username');
        $this->_password = config('cart-rover-cart.api_key');
    }

    /**
     * @param Order $order
     * @return mixed
     */
    public function handle(Order $order): mixed
    {
        $response = Http::asJson()
            ->withBasicAuth($this->_username, $this->_password)
            ->post(sprintf('%s/orders/cartrover', $this->_url), $order->toJson());

        if ($response->successful()) {
            return $response->json();
        }
    }
}