<?php

namespace Ptb\CartRover\Tests\Feature;

use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Http;
use Ptb\CartRover\Cart\Actions\CancelOrder;
use Ptb\CartRover\Cart\Actions\NewOrder;
use Ptb\CartRover\Cart\Actions\NewOrders;
use Ptb\CartRover\Cart\Actions\UpdateOrderStatus;
use Ptb\CartRover\Cart\Actions\ViewOrder;
use Ptb\CartRover\Cart\Actions\ViewOrdersByStatus;
use Ptb\CartRover\Cart\Actions\ViewOrderStatus;
use Ptb\CartRover\Cart\Models\Order;
use Ptb\CartRover\Tests\TestCase;

class PackageTest extends TestCase
{
    /** @test */
    public function can_load_config()
    {
        $config = config('cart-rover-cart');

        $this->assertArrayHasKey('api_username', $config);
        $this->assertArrayHasKey('api_key', $config);
    }

    /** @test */
    public function can_cancel_order()
    {
        $response = json_decode(file_get_contents(__DIR__ . '/../Fixtures/CancelOrder_success.json'), true);
        Http::fake([
            config('cart-rover-cart.api_url') . '/*' => Http::response($response, 200),
        ]);

        $reference = 'TEST01';
        $action = new CancelOrder;
        $result = $action->handle($reference);

        $this->assertArrayHasKey('success_code', $result);
    }

    /** @test */
    public function can_create_order()
    {
        $response = json_decode(file_get_contents(__DIR__ . '/../Fixtures/NewOrder_success.json'), true);
        Http::fake([
            config('cart-rover-cart.api_url') . '/*' => Http::response($response, 200),
        ]);

        $request = json_decode(file_get_contents(__DIR__ . '/../Fixtures/Requests/NewOrder.json'), true);
        $action = new NewOrder;
        $result = $action->handle(Order::make($request));

        $this->assertArrayHasKey('success_code', $result);
    }

    /** @test */
    public function can_create_orders()
    {
        $response = json_decode(file_get_contents(__DIR__ . '/../Fixtures/NewOrder_success.json'), true);
        Http::fake([
            config('cart-rover-cart.api_url') . '/*' => Http::response($response, 200),
        ]);

        $request = json_decode(file_get_contents(__DIR__ . '/../Fixtures/Requests/NewOrders.json'), true);
        $action = new NewOrders;
        $result = $action->handle(collect($request));

        $this->assertArrayHasKey('success_code', $result);
    }

    /** @test */
    public function can_update_order_status()
    {
        $response = json_decode(file_get_contents(__DIR__ . '/../Fixtures/UpdateOrderStatus_success.json'), true);
        Http::fake([
            config('cart-rover-cart.api_url') . '/*' => Http::response($response, 200),
        ]);

        $reference = 'TEST01';
        $action = new UpdateOrderStatus;
        $result = $action->handle($reference, Order::StatusConfirmed, []);

        $this->assertArrayHasKey('success_code', $result);
    }

    /** @test */
    public function can_view_order()
    {
        $view_order_response = json_decode(file_get_contents(__DIR__ . '/../Fixtures/ViewOrder_success.json'), true);
        Http::fake([
            config('cart-rover-cart.api_url') . '/*' => Http::response($view_order_response, 200),
        ]);

        $reference = 'TEST07Auto';
        $action = new ViewOrder;
        $order = $action->handle($reference);

        $this->assertInstanceOf(Order::class, $order);
    }

    /** @test */
    public function can_view_orders_by_status()
    {
        $view_order_response = json_decode(file_get_contents(__DIR__ . '/../Fixtures/ViewOrdersByStatus_success.json'), true);
        Http::fake([
            config('cart-rover-cart.api_url') . '/*' => Http::response($view_order_response, 200),
        ]);

        $action = new ViewOrdersByStatus();
        $orders = $action->handle(Order::StatusAtWms);

        $this->assertInstanceOf(Collection::class, $orders);
    }

    /** @test */
    public function can_view_order_status()
    {
        $view_order_response = json_decode(file_get_contents(__DIR__ . '/../Fixtures/ViewOrderStatus_success.json'), true);
        Http::fake([
            config('cart-rover-cart.api_url') . '/*' => Http::response($view_order_response, 200),
        ]);

        $reference = '349347';
        $action = new ViewOrderStatus;
        $result = $action->handle($reference);

        $this->assertArrayHasKey('success_code', $result);
        $this->assertArrayHasKey('response', $result);
        $this->assertTrue($result['success_code']);
        $this->assertEquals($reference, $result['response']['cust_ref']);
    }
}