<?php

namespace Ptb\CartRover\Cart\Models;

use Illuminate\Contracts\Support\Jsonable;
use Ptb\CartRover\Cart\Contracts\CanHydrateFromArray;
use function data_get;

class OrderItem implements Jsonable, CanHydrateFromArray
{
    /**
     * @var ?float
     * An additional post-tax discount applied to the line item total.
     * Up to 4 decimals places
     */
    public ?float $addl_discount;

    /**
     * @var ?string
     * Note the capital "D".
     * It's there due to legacy stuff.
     */
    public ?string $Description;

    /**
     * @var ?float
     * The discount amount for a single unit or item.
     * Up to 4 decimals places
     */
    public ?float $discount;

    /**
     * @var ?float
     * 2 decimals places
     */
    public ?float $extended_discount;

    /**
     * @var ?array
     * Key-Value list of Line Item extra field names and values to post.
     * Max 10.
     * Eg: {"extra_fields": {"some_custom_name":"Some Custom Value", "another_custom_name":"Some Other Custom Value"}}
     */
    public ?array $extra_fields;

    /**
     * @var string
     * Product SKU - Must match product in warehouse
     */
    public string $item;

    /**
     * @var string|null
     */
    public ?string $line_comment;

    /**
     * @var ?string
     * Optional additional line ID from cart
     */
    public ?string $line_item_id;

    /**
     * @var ?int
     * Optional Line Number
     */
    public ?int $line_no;

    /**
     * @var ?string
     */
    public ?string $lot_number;

    /**
     * @var ?float
     * Up to 4 decimals places
     */
    public ?float $price;

    /**
     * @var int
     */
    public int $quantity;

    /**
     * @var ?float
     * 2 decimals places
     */
    public ?float $shipping_surcharge;

    /**
     * @var ?float
     * 2 decimals places
     */
    public ?float $tax;

    /**
     * @param array $attributes
     * @return OrderItem
     */
    public static function make(array $attributes = []): OrderItem
    {
        $vars = get_class_vars(self::class);
        $item = new self;
        foreach ($vars as $var => $ignore) {
            $item->$var = match ($var) {
                'item' => data_get($attributes, $var, ''),
                'quantity' => data_get($attributes, $var, 0),
                default => data_get($attributes, $var)
            };
        }

        return $item;
    }

    /**
     * @param int $options
     * @return array
     */
    public function toJson($options = 0): array
    {
        $data = [];
        $vars = get_class_vars(self::class);
        foreach ($vars as $var => $ignore) {
            if (!is_null($this->$var)) {
                $data[$var] = match ($var) {
                    default => $this->$var
                };
            }
        }

        return $data;
    }
}
