<?php

namespace Ptb\CartRover\Cart\Actions;

use Illuminate\Support\Facades\Http;
use Ptb\CartRover\Cart\Models\Error;
use Ptb\CartRover\Cart\Models\Order;

class UpdateOrderStatus
{
    protected string $_username;
    protected string $_password;
    protected string $_url;

    public function __construct()
    {
        $this->_url = config('cart-rover-cart.api_url');
        $this->_username = config('cart-rover-cart.api_username');
        $this->_password = config('cart-rover-cart.api_key');
    }

    /**
     * @param string $reference
     * @param string $status
     * @param array $shipments
     * @return mixed
     */
    public function handle(string $reference, string $status, array $shipments = []): mixed
    {
        $response = Http::asJson()
            ->withBasicAuth($this->_username, $this->_password)
            ->post(sprintf('%s/orders/update/%s', $this->_url, $reference), [
                'order_status' => $status,
                'shipments' => $shipments
            ]);

        if ($response->successful()) {
            return $response->json();
        }
    }
}