<?php

namespace Ptb\CartRover\Cart\Actions;

use Illuminate\Support\Facades\Http;

class CancelOrder
{
    protected string $_username;
    protected string $_password;
    protected string $_url;

    public function __construct()
    {
        $this->_url = config('cart-rover-cart.api_url');
        $this->_username = config('cart-rover-cart.api_username');
        $this->_password = config('cart-rover-cart.api_key');
    }

    /**
     * @param string $reference
     * @return mixed
     */
    public function handle(string $reference): mixed
    {
        $response = Http::asJson()
            ->withBasicAuth($this->_username, $this->_password)
            ->get(sprintf('%s/orders/wms_cancel/%s', $this->_url, $reference));

        if ($response->successful()) {
            return $response->json();
        }
    }
}