<?php

namespace Ptb\Grafx\Resource;

use Ptb\Grafx\Enums\PreviewType;
use Ptb\Grafx\Requests\Templates\CreateTemplate;
use Ptb\Grafx\Requests\Templates\DeleteTemplate;
use Ptb\Grafx\Requests\ReadTemplateDownloadRequest;
use Ptb\Grafx\Requests\Templates\GetTemplates;
use Ptb\Grafx\Requests\ReadTemplatesRequest;
use Ptb\Grafx\Requests\ReadTemplatePreviewRequest;
use Ptb\Grafx\Requests\ReadTemplatePreviewStatusRequest;
use Ptb\Grafx\Requests\ReadTemplateRequest;
use Ptb\Grafx\Requests\Templates\ReturnsTheTemplateCollectionsThatContainTheTemplate;
use Ptb\Grafx\Requests\Templates\StoresTemplateInTemplateCollections;
use Ptb\Grafx\Requests\UpdateTemplateRequest;
use Ptb\Grafx\Resource\AbstractResource;
use Saloon\Exceptions\Request\FatalRequestException;
use Saloon\Exceptions\Request\RequestException;
use Saloon\Http\Response;

class TemplatePreviewStatusResource extends AbstractResource
{
    /**
     * @param string $id The unique identifier for the task to check preview status.
     * @return Response The response containing the status of the template preview.
     * @throws FatalRequestException If a critical error occurs during the request.
     * @throws RequestException If the request fails due to a non-critical error.
     */
    public function show(string $id): Response
    {
        return $this->connector->send(
            request: new ReadTemplatePreviewStatusRequest(
                environment: config('services.grafx.environment'),
                taskId: $id,
            ),
        );
    }
}
