<?php

namespace Ptb\Grafx\Resource;

use Ptb\Grafx\Requests\ReadTemplateCollectionRequest;
use Ptb\Grafx\Requests\ReadTemplateCollectionsRequest;
use Ptb\Grafx\Requests\ReadTemplateCollectionTemplatesRequest;
use Saloon\Exceptions\Request\FatalRequestException;
use Saloon\Exceptions\Request\RequestException;
use Saloon\Http\Response;

class TemplateCollectionResource extends AbstractResource
{
    /**
     * @param string|null $nextPageToken
     * @param int|null $limit
     * @return Response
     * @throws FatalRequestException
     * @throws RequestException
     */
    public function index(?string $nextPageToken = null, ?int $limit = null): Response
    {
        return $this->connector->send(
            request: new ReadTemplateCollectionsRequest(
                environment: config('services.grafx.environment'),
                nextPageToken: $nextPageToken,
                limit: $limit,
            ),
        );
    }

    /**
     * @param string $id
     * @return Response
     * @throws FatalRequestException
     * @throws RequestException
     */
    public function show(string $id): Response
    {
        return $this->connector->send(
            request: new ReadTemplateCollectionRequest(
                environment: config('services.grafx.environment'),
                templateCollectionId: $id,
            ),
        );
    }

    /**
     * @param string $id
     * @return Response
     * @throws FatalRequestException
     * @throws RequestException
     */
    public function templates(string $id): Response
    {
        return $this->connector->send(
            request: new ReadTemplateCollectionTemplatesRequest(
                environment: config('services.grafx.environment'),
                templateCollectionId: $id,
            )
        );
    }
}
