<?php

namespace Ptb\Grafx\Resource;

use Ptb\Grafx\Enums\OutputType;
use Ptb\Grafx\Requests\ReadTaskOutputRequest;
use Ptb\Grafx\Requests\ReadTaskRequest;
use Ptb\Grafx\Requests\StoreTaskRequest;
use Ptb\Grafx\Resource\AbstractResource;
use Saloon\Exceptions\Request\FatalRequestException;
use Saloon\Exceptions\Request\RequestException;
use Saloon\Http\Response;

class TaskOutputResource extends AbstractResource
{
    /**
     * Retrieves the output of a specific task based on the provided task ID.
     *
     * @param string $id The unique identifier of the task.
     * @return Response The response containing the task output.
     * @throws FatalRequestException
     * @throws RequestException
     */
    public function show(string $id): Response
    {
        return $this->connector->send(
            request: new ReadTaskOutputRequest(
                environment: config('services.grafx.environment'),
                taskId: $id,
            ),
        );
    }
}
