<?php

namespace Ptb\Grafx\Resource;

use Ptb\Grafx\Enums\OutputType;
use Ptb\Grafx\Requests\ReadTaskErrorsRequest;
use Ptb\Grafx\Requests\ReadTaskOutputRequest;
use Ptb\Grafx\Requests\ReadTaskRequest;
use Ptb\Grafx\Requests\StoreTaskRequest;
use Ptb\Grafx\Resource\AbstractResource;
use Saloon\Exceptions\Request\FatalRequestException;
use Saloon\Exceptions\Request\RequestException;
use Saloon\Http\Response;

class TaskOutputErrorResource extends AbstractResource
{
    /**
     * Retrieves the error report for a specified task ID.
     *
     * @param string $id The unique identifier of the task for which the error report is to be retrieved.
     * @return Response The response object containing the error report details.
     * @throws FatalRequestException
     * @throws RequestException
     */
    public function show(string $id): Response
    {
        return $this->connector->send(
            request: new ReadTaskErrorsRequest(
                environment: config('services.grafx.environment'),
                taskId: $id,
            ),
        );
    }
}
