<?php

namespace Ptb\Grafx\Resource;

use Ptb\Grafx\Requests\StoreProjectRequest;
use Ptb\Grafx\Requests\DeleteProjectRequest;
use Ptb\Grafx\Requests\UpdateProjectRequest;
use Ptb\Grafx\Requests\ReadProjectsRequest;
use Ptb\Grafx\Requests\ReadProjectPreviewRequest;
use Ptb\Grafx\Requests\ReadProjectRequest;
use Ptb\Grafx\Requests\ReadProjectDocumentRequest;
use Ptb\Grafx\Requests\ReadProjectPreviewStatusRequest;
use Ptb\Grafx\Requests\UpdateProjectDocumentRequest;
use Ptb\Grafx\Resource\AbstractResource;
use Saloon\Exceptions\Request\FatalRequestException;
use Saloon\Exceptions\Request\RequestException;
use Saloon\Http\Response;

class ProjectResource extends AbstractResource
{
    /**
     * @param string|null $nextPageToken
     * @param int|null $limit
     * @return Response
     * @throws FatalRequestException
     * @throws RequestException
     */
    public function index(?string $nextPageToken = null, ?int $limit = null): Response
    {
        return $this->connector->send(
            request: new ReadProjectsRequest(
                environment: config('services.grafx.environment'),
                nextPageToken: $nextPageToken,
                limit: $limit
            ),
        );
    }

    /**
     * @param string $id
     * @return Response
     * @throws FatalRequestException
     * @throws RequestException
     */
    public function show(string $id): Response
    {
        return $this->connector->send(
            request: new ReadProjectRequest(
                environment: config('services.grafx.environment'),
                projectId: $id,
            ),
        );
    }

    /**
     * @param array $data
     * @return Response
     * @throws FatalRequestException
     * @throws RequestException
     */
    public function store(array $data): Response
    {
        return $this->connector->send(
            request: new StoreProjectRequest(
                environment: config('services.grafx.environment'),
                data: $data,
            ),
        );
    }

    /**
     * @param string $id
     * @param array $data
     * @return Response
     * @throws FatalRequestException
     * @throws RequestException
     */
    public function update(string $id, array $data): Response
    {
        return $this->connector->send(
            request: new UpdateProjectRequest(
                environment: config('services.grafx.environment'),
                projectId: $id,
                data: $data,
            ),
        );
    }

    /**
     * @param string $id
     * @return Response
     * @throws FatalRequestException
     * @throws RequestException
     */
    public function destroy(string $id): Response
    {
        return $this->connector->send(
            request: new DeleteProjectRequest(
                environment: config('services.grafx.environment'),
                projectId: $id,
            ),
        );
    }
}
