<?php

namespace Ptb\Grafx\Resource;

use Ptb\Grafx\Requests\StoreProjectRequest;
use Ptb\Grafx\Requests\DeleteProjectRequest;
use Ptb\Grafx\Requests\UpdateProjectRequest;
use Ptb\Grafx\Requests\ReadProjectsRequest;
use Ptb\Grafx\Requests\ReadProjectPreviewRequest;
use Ptb\Grafx\Requests\ReadProjectRequest;
use Ptb\Grafx\Requests\ReadProjectDocumentRequest;
use Ptb\Grafx\Requests\ReadProjectPreviewStatusRequest;
use Ptb\Grafx\Requests\UpdateProjectDocumentRequest;
use Ptb\Grafx\Resource\AbstractResource;
use Saloon\Exceptions\Request\FatalRequestException;
use Saloon\Exceptions\Request\RequestException;
use Saloon\Http\Response;

class ProjectDocumentUrlResource extends AbstractResource
{
    /**
     * @param string $id
     * @return string
     */
    public function show(string $id): string
    {
        $request = new ReadProjectDocumentRequest(environment: config('services.grafx.environment'), projectId: $id);

        return $request->resolveEndpoint();
    }
}
