<?php

namespace Ptb\Grafx\Requests;

use DateTime;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

/**
 * Updates My Project document
 *
 * Updates My Project document
 */
class UpdateProjectDocumentRequest extends Request implements HasBody
{

    use HasJsonBody;

    protected Method $method = Method::PUT;

    public function resolveEndpoint(): string
    {
        return "/api/v1/environment/$this->environment/projects/$this->projectId/document";
    }

    protected function defaultBody(): array
    {
        return $this->data;
    }

    public function __construct(
        protected string $environment,
        protected string $projectId,
        protected array  $data,
    )
    {
    }
}
