<?php

namespace Ptb\Grafx\Requests;

use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Represents a request to retrieve all templates from a specified environment.
 * This request allows optional parameters to filter, sort, and limit the results.
 *
 * The endpoint for this request is dynamically resolved based on the provided environment.
 *
 * Query parameters:
 * - nextPageToken: Used for pagination to indicate the starting point for the next set of results.
 * - limit: Limits the number of results returned.
 * - sortBy: Indicates the field by which the results should be sorted.
 * - sortOrder: Determines the order of sorting, e.g., ascending or descending.
 * - search: A search term to filter the results based on relevant criteria.
 */
class ReadTemplatesRequest extends Request
{
    protected Method $method = Method::GET;


    public function resolveEndpoint(): string
    {
        return "/api/v1/environment/$this->environment/templates";
    }

    public function defaultQuery(): array
    {
        return array_filter([
            'nextPageToken' => $this->nextPageToken,
            'limit' => $this->limit,
            'sortBy' => $this->sortBy,
            'sortOrder' => $this->sortOrder,
            'search' => $this->search,
        ]);
    }

    public function __construct(
        protected string  $environment,
        protected ?string $nextPageToken = null,
        protected ?int    $limit = null,
        protected ?string $sortBy = null,
        protected mixed   $sortOrder = null,
        protected ?string $search = null,
    )
    {
    }
}
