<?php

namespace Ptb\Grafx\Requests;

use DateTime;
use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Represents a request to retrieve a specific template associated with an environment.
 *
 * This class is responsible for constructing the endpoint to access
 * a template based on the provided environment and template ID.
 *
 * The HTTP method for this request is GET.
 */
class ReadTemplateRequest extends Request
{
    protected Method $method = Method::GET;

    public function resolveEndpoint(): string
    {
        return "/api/v1/environment/$this->environment/templates/$this->templateId";
    }

    public function __construct(
        protected string $environment,
        protected string $templateId,
    )
    {
    }
}
