<?php

namespace Ptb\Grafx\Requests;

use DateTime;
use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Represents a request to retrieve a preview of a specific template.
 *
 * This class is used to make an API call to fetch the preview of a template
 * identified by its ID within a specified environment. Optionally, a preview type
 * can be provided to customize the behavior of the preview generation.
 *
 * Attributes provided include the environment, template ID, and an optional
 * preview type parameter.
 */
class ReadTemplatePreviewRequest extends Request
{
    protected Method $method = Method::GET;

    public function resolveEndpoint(): string
    {
        return "/api/v1/environment/$this->environment/templates/$this->templateId/preview";
    }

    protected function defaultQuery(): array
    {
        return array_filter([
            'previewType' => $this->previewType,
        ]);
    }

    public function __construct(
        protected string  $environment,
        protected string  $templateId,
        protected ?string $previewType = null,
    )
    {
    }
}
