<?php

namespace Ptb\Grafx\Requests;

use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Represents a request to delete output settings for a specified environment.
 *
 * This class extends the base Request class and is used to perform DELETE operations
 * on the output settings endpoint of the API for a given environment.
 *
 * The request requires the environment identifier and the IDs of the output settings
 * to be deleted.
 */
class DeleteOutputSettingRequest extends Request
{
    protected Method $method = Method::DELETE;

    public function resolveEndpoint(): string
    {
        return "/api/v1/environment/$this->environment/output/settings";
    }

    public function __construct(
        protected string $environment,
        protected array  $ids,
    )
    {
    }


    public function defaultQuery(): array
    {
        return array_filter([
            'ids' => $this->ids
        ]);
    }
}
