<?php

namespace Ptb\Grafx\Resource;

use Ptb\Grafx\Enums\PreviewType;
use Ptb\Grafx\Requests\Templates\CreateTemplate;
use Ptb\Grafx\Requests\Templates\DeleteTemplate;
use Ptb\Grafx\Requests\ReadTemplateDownloadRequest;
use Ptb\Grafx\Requests\Templates\GetTemplates;
use Ptb\Grafx\Requests\ReadTemplatesRequest;
use Ptb\Grafx\Requests\ReadTemplatePreviewRequest;
use Ptb\Grafx\Requests\ReadTemplatePreviewStatusRequest;
use Ptb\Grafx\Requests\ReadTemplateRequest;
use Ptb\Grafx\Requests\Templates\ReturnsTheTemplateCollectionsThatContainTheTemplate;
use Ptb\Grafx\Requests\Templates\StoresTemplateInTemplateCollections;
use Ptb\Grafx\Requests\UpdateTemplateRequest;
use Ptb\Grafx\Resource\AbstractResource;
use Saloon\Exceptions\Request\FatalRequestException;
use Saloon\Exceptions\Request\RequestException;
use Saloon\Http\Response;

class TemplateResource extends AbstractResource
{
    /**
     * @param string|null $nextPageToken
     * @param int|null $limit
     * @param string|null $sortBy
     * @param string|null $sortOrder
     * @param string|null $search
     * @return Response
     * @throws FatalRequestException
     * @throws RequestException
     */
    public function index(?string $nextPageToken = null, ?int $limit = null, ?string $sortBy = null, ?string $sortOrder = null, ?string $search = null): Response
    {
        return $this->connector->send(
            request: new ReadTemplatesRequest(
                environment: config('services.grafx.environment'),
                nextPageToken: $nextPageToken,
                limit: $limit,
                sortBy: $sortBy,
                sortOrder: $sortOrder,
                search: $search
            ),
        );
    }

    /**
     * @param string $id
     * @return Response
     * @throws FatalRequestException
     * @throws RequestException
     */
    public function show(string $id): Response
    {
        return $this->connector->send(
            request: new ReadTemplateRequest(
                environment: config('services.grafx.environment'),
                templateId: $id,
            ),
        );
    }

    /**
     * @param string $id The unique identifier of the template to be updated.
     * @param array $data An associative array containing the data to update the template with.
     * @return Response
     * @throws FatalRequestException
     * @throws RequestException
     */
    public function update(string $id, array $data): Response
    {
        return $this->connector->send(
            request: new UpdateTemplateRequest(
                environment: config('services.grafx.environment'),
                templateId: $id,
                data: $data,
            ),
        );
    }
}
