<?php

namespace Ptb\Grafx\Resource;

use Ptb\Grafx\Enums\PreviewType;
use Ptb\Grafx\Requests\Templates\CreateTemplate;
use Ptb\Grafx\Requests\Templates\DeleteTemplate;
use Ptb\Grafx\Requests\ReadTemplateDownloadRequest;
use Ptb\Grafx\Requests\Templates\GetTemplates;
use Ptb\Grafx\Requests\ReadTemplatesRequest;
use Ptb\Grafx\Requests\ReadTemplatePreviewRequest;
use Ptb\Grafx\Requests\ReadTemplatePreviewStatusRequest;
use Ptb\Grafx\Requests\ReadTemplateRequest;
use Ptb\Grafx\Requests\Templates\ReturnsTheTemplateCollectionsThatContainTheTemplate;
use Ptb\Grafx\Requests\Templates\StoresTemplateInTemplateCollections;
use Ptb\Grafx\Requests\UpdateTemplateRequest;
use Ptb\Grafx\Resource\AbstractResource;
use Saloon\Exceptions\Request\FatalRequestException;
use Saloon\Exceptions\Request\RequestException;
use Saloon\Http\Response;

class TemplateDownloadResource extends AbstractResource
{
    /**
     * @param string $id
     * @return Response
     * @throws FatalRequestException
     * @throws RequestException
     */
    public function show(string $id): Response
    {
        return $this->connector->send(
            request: new ReadTemplateDownloadRequest(
                environment: config('services.grafx.environment'),
                templateId: $id,
            ),
        );
    }
}
