<?php

namespace Ptb\Grafx\Resource;


use Illuminate\Support\Arr;
use Ptb\Grafx\Enums\OutputType;
use Ptb\Grafx\Requests\ReadOutputSettingsRequest;
use Ptb\Grafx\Requests\ReadOutputSettingRequest;
use Ptb\Grafx\Requests\StoreOutputSettingRequest;
use Ptb\Grafx\Requests\DeleteOutputSettingRequest;
use Ptb\Grafx\Requests\UpdateOutputSettingRequest;
use Saloon\Exceptions\Request\FatalRequestException;
use Saloon\Exceptions\Request\RequestException;
use Saloon\Http\Response;

class OutputSettingResource extends AbstractResource
{

    /**
     * @return Response
     * @throws FatalRequestException
     * @throws RequestException
     */
    public function index(): Response
    {
        return $this->connector->send(
            request: new ReadOutputSettingsRequest(
                environment: config('services.grafx.environment'),
            ),
        );
    }

    /**
     * @param string $id
     * @return Response
     * @throws FatalRequestException
     * @throws RequestException
     */
    public function show(string $id): Response
    {
        return $this->connector->send(
            request: new ReadOutputSettingRequest(
                environment: config('services.grafx.environment'),
                outputSettingsId: $id,
            ),
        );
    }

    /**
     * @param OutputType $type
     * @param array $data
     * @return Response
     * @throws FatalRequestException
     * @throws RequestException
     */
    public function store(OutputType $type, array $data): Response
    {
        return $this->connector->send(
            request: new StoreOutputSettingRequest(
                environment: config('services.grafx.environment'),
                type: $type->value,
                data: $data,
            ),
        );
    }

    /**
     * @param string $id
     * @param array $data
     * @return Response
     * @throws FatalRequestException
     * @throws RequestException
     */
    public function update(string $id, array $data): Response
    {
        return $this->connector->send(
            request: new UpdateOutputSettingRequest(
                environment: config('services.grafx.environment'),
                outputSettingsId: $id,
                data: $data,
            ),
        );
    }

    /**
     * @param string $id
     * @return Response
     * @throws FatalRequestException
     * @throws RequestException
     */
    public function destroy(string $id): Response
    {
        return $this->connector->send(
            request: new DeleteOutputSettingRequest(
                environment: config('services.grafx.environment'),
                ids: Arr::wrap($id),
            ),
        );
    }
}
