<?php

namespace Ptb\Grafx\Requests;

use DateTime;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

/**
 * Represents a request to update a specific template within a given environment.
 *
 * This request is sent using the PUT HTTP method and requires the environment,
 * template ID, and data to update the template.
 *
 * The endpoint for this request is dynamically resolved based on the provided
 * environment and template ID.
 *
 * Implements the HasBody interface to indicate that the request contains a body,
 * and utilizes the HasJsonBody trait to handle JSON-encoded body data.
 */
class UpdateTemplateRequest extends Request implements HasBody
{
    use HasJsonBody;

    protected Method $method = Method::PUT;

    public function resolveEndpoint(): string
    {
        return "/api/v1/environment/$this->environment/templates/$this->templateId";
    }

    protected function defaultBody(): array
    {
        return $this->data;
    }

    public function __construct(
        protected string $environment,
        protected string $templateId,
        protected array  $data,
    )
    {
    }
}
