<?php

namespace Ptb\Grafx\Requests;

use DateTime;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

/**
 * Represents a request to patch a project in a specific environment.
 *
 * Extends the base Request class and implements the HasBody interface to
 * handle JSON payloads. The request is sent using the PATCH HTTP method.
 *
 * The endpoint is resolved dynamically based on the provided environment
 * and project ID.
 *
 * Constructor parameters:
 * - $environment: The identifier for the environment.
 * - $projectId: The identifier for the project.
 * - $data: The data to be included in the request body.
 */
class UpdateProjectRequest extends Request implements HasBody
{
    use HasJsonBody;

    protected Method $method = Method::PATCH;


    public function resolveEndpoint(): string
    {
        return "/api/v1/environment/$this->environment/projects/$this->projectId";
    }

    protected function defaultBody(): array
    {
        return $this->data;
    }

    public function __construct(
        protected string $environment,
        protected string $projectId,
        protected array  $data,
    )
    {
    }
}
