<?php

namespace Ptb\Grafx\Requests;

use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

/**
 * Represents a request to update the output settings for a specific environment
 * using the PUT HTTP method. This class constructs the necessary endpoint
 * for making the request.
 */
class UpdateOutputSettingRequest extends Request implements HasBody
{
    use HasJsonBody;

    protected Method $method = Method::PUT;

    public function resolveEndpoint(): string
    {
        return "/api/v1/environment/$this->environment/output/settings/$this->outputSettingsId";
    }

    protected function defaultBody(): array
    {
        return $this->data;
    }

    public function __construct(
        protected string $environment,
        protected string $outputSettingsId,
        protected array  $data,
    )
    {
    }
}
