<?php

namespace Ptb\Grafx\Requests\TemplateCollections;

use DateTime;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

/**
 * Creates a new template collection in the environment
 *
 * Creates a new template collection in the environment, takes template collection JSON from the
 * request body
 */
class CreatesNewTemplateCollectionInTheEnvironment extends Request implements HasBody
{
	use HasJsonBody;

	protected Method $method = Method::POST;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/template-collections";
	}


	/**
	 * @param string $environment Name of the environment
	 */
	public function __construct(
		protected string $environment,
	) {
	}
}
