<?php

namespace Ptb\Grafx\Requests;

use DateTime;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

/**
 * Represents a task to send a POST request to a specified output endpoint.
 * This class constructs the endpoint URL dynamically using the provided environment and type parameters.
 * It uses JSON as the body format for the request.
 */
class StoreTaskRequest extends Request implements HasBody
{
    use HasJsonBody;

    protected Method $method = Method::POST;

    public function resolveEndpoint(): string
    {
        return "/api/v1/environment/$this->environment/output/$this->type";
    }

    protected function defaultBody(): array
    {
        return $this->data;
    }

    public function __construct(
        protected string $environment,
        protected string $type,
        protected array  $data,
    )
    {
    }
}
