<?php

namespace Ptb\Grafx\Requests;

use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

/**
 * Handles the request to post output settings for a specific environment and type.
 *
 * Extends the base Request class and implements HasBody to support requests with a body.
 * Utilizes the HasJsonBody trait to properly format the request body as JSON.
 *
 * Provides functionality to dynamically resolve the API endpoint using
 * the provided environment and type properties during object construction.
 */
class StoreOutputSettingRequest extends Request implements HasBody
{
    use HasJsonBody;

    protected Method $method = Method::POST;

    public function resolveEndpoint(): string
    {
        return "/api/v1/environment/$this->environment/output/settings/$this->type";
    }

    protected function defaultBody(): array
    {
        return $this->data;
    }

    public function __construct(
        protected string $environment,
        protected string $type,
        protected array  $data,
    )
    {
    }
}
