<?php

namespace Ptb\Grafx\Requests;

use DateTime;
use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Represents a request to retrieve the status of a template preview task
 * identified by a specific environment and task ID.
 *
 * Extends the base Request class and sends a GET request to the API
 * endpoint dedicated to fetching the status of a template preview task.
 */
class ReadTemplatePreviewStatusRequest extends Request
{
    protected Method $method = Method::GET;


    public function resolveEndpoint(): string
    {
        return "/api/v1/environment/$this->environment/templates/preview/tasks/$this->taskId";
    }

    public function __construct(
        protected string $environment,
        protected string $taskId,
    )
    {
    }
}
