<?php

namespace Ptb\Grafx\Requests;

use DateTime;
use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Represents a request to download a specific template from an environment.
 *
 * This class constructs the appropriate endpoint to fetch the requested
 * template for the given environment.
 */
class ReadTemplateDownloadRequest extends Request
{
    protected Method $method = Method::GET;

    public function resolveEndpoint(): string
    {
        return "/api/v1/environment/$this->environment/templates/$this->templateId/download";
    }

    public function __construct(
        protected string $environment,
        protected string $templateId,
    )
    {
    }
}
