<?php

namespace Ptb\Grafx\Requests;

use DateTime;
use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Handles a request to read template collections for a specified environment.
 * Provides functionality to set query parameters such as pagination and result limits.
 */
class ReadTemplateCollectionsRequest extends Request
{
	protected Method $method = Method::GET;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/$this->environment/template-collections";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param null|string $nextPageToken Next page token
	 * @param null|int $limit Amount of resources per response
	 */
	public function __construct(
		protected string $environment,
		protected ?string $nextPageToken = null,
		protected ?int $limit = null,
	) {
	}


	public function defaultQuery(): array
	{
		return array_filter(['nextPageToken' => $this->nextPageToken, 'limit' => $this->limit]);
	}
}
