<?php

namespace Ptb\Grafx\Requests;

use DateTime;
use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Represents a request to retrieve error reports for a specific task in a given environment.
 *
 * This class handles the HTTP request for obtaining details about task-specific errors.
 * It constructs the endpoint URL dynamically based on the provided environment and task ID.
 */
class ReadTaskErrorsRequest extends Request
{
    protected Method $method = Method::GET;

    public function resolveEndpoint(): string
    {
        return "/api/v1/environment/$this->environment/output/tasks/$this->taskId/error-report";
    }

    public function __construct(
        protected string $environment,
        protected string $taskId,
    )
    {
    }
}
