<?php

namespace Ptb\Grafx\Requests;

use DateTime;
use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Returns My project by ID in the environment
 *
 * Returns My project by ID in the environment
 */
class ReadProjectRequest extends Request
{
	protected Method $method = Method::GET;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/projects/{$this->projectId}";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $projectId My Project ID
	 */
	public function __construct(
		protected string $environment,
		protected string $projectId,
	) {
	}
}
