<?php

namespace Ptb\Grafx\Requests;

use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

/**
 * Represents a request to retrieve output settings for a specific environment and output settings ID.
 *
 * This class is used to define the necessary parameters and endpoint required to
 * fetch the output settings from the API.
 *
 * @property string $environment The identifier of the environment for which the output settings are being retrieved.
 * @property string $outputSettingsId The unique identifier for the specific output settings to retrieve.
 */
class ReadOutputSettingRequest extends Request
{

    protected Method $method = Method::GET;

    public function resolveEndpoint(): string
    {
        return "/api/v1/environment/$this->environment/output/settings/$this->outputSettingsId";
    }

    public function __construct(
        protected string $environment,
        protected string $outputSettingsId,
    )
    {
    }
}
