<?php

namespace Ptb\Grafx\Resource;

use Ptb\Grafx\Enums\OutputType;
use Ptb\Grafx\Requests\ReadTaskOutputRequest;
use Ptb\Grafx\Requests\ReadTaskRequest;
use Ptb\Grafx\Requests\StoreTaskRequest;
use Ptb\Grafx\Resource\AbstractResource;
use Saloon\Exceptions\Request\FatalRequestException;
use Saloon\Exceptions\Request\RequestException;
use Saloon\Http\Response;

class TaskResource extends AbstractResource
{
    /**
     * Retrieves the task associated with the given task ID.
     *
     * @param string $id The unique identifier of the task to retrieve.
     * @return Response The response containing the task details.
     * @throws FatalRequestException
     * @throws RequestException
     */
    public function show(string $id): Response
    {
        return $this->connector->send(
            request: new ReadTaskRequest(
                environment: config('services.grafx.environment'),
                taskId: $id,
            ),
        );
    }

    /**
     * Creates a new task with the specified output type and data.
     *
     * @param OutputType $type The type of output to be generated for the task.
     * @param array $data The data required to create the task.
     * @return Response The response object containing the details of the newly created task.
     * @throws FatalRequestException
     * @throws RequestException
     */
    public function store(OutputType $type, array $data): Response
    {
        return $this->connector->send(
            request: new StoreTaskRequest(
                environment: config('services.grafx.environment'),
                type: $type->value,
                data: $data,
            ),
        );
    }
}
