<?php

namespace Ptb\Grafx\Requests\TemplateCollections;

use DateTime;
use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Sets or updates image cover of template collection
 *
 * Sets or updates image cover of template collection. Supported media formats: jpg/jpeg, png, tiff,
 * webp
 */
class SetsOrUpdatesImageCoverOfTemplateCollection extends Request
{
	protected Method $method = Method::PUT;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/template-collections/{$this->templateCollectionId}/cover";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $templateCollectionId ID of the template collection
	 */
	public function __construct(
		protected string $environment,
		protected string $templateCollectionId,
	) {
	}
}
